/*
    Autor: Răileanu Alin-Gabriel
    Problemă: Harap Alb
*/
#include <fstream>
#include <stack>
#include <algorithm>
const int NMAX=3e6;

using namespace std;
ifstream fin("harapalb.in");
ofstream fout("harapalb.out");

struct indici
{
    int st, dr;
    bool operator<(const indici& other) const
    {
        if(st==other.st) return dr<other.dr;
        return st<other.st;
    }

    bool operator!=(const indici& other) const
    {
        return (st!=other.st || dr!=other.dr);
    }

} v[NMAX];

stack< int > st;
int n, a[NMAX], maxim, ans;

bool ok(indici);

signed main()
{
    ios_base::sync_with_stdio(false);
    fin.tie(0);
    int i, cer;
    fin>>cer>>n;
    for(i=1; i<=n; i++) fin>>a[i];
    for(i=1; i<=n; i++)
    {
        while(!st.empty() && a[st.top()]>a[i])
        {
            v[st.top()].dr=i;
            st.pop();
        }
        st.push(i);
    }
    while(!st.empty())
    {
        v[st.top()].dr=n+1;
        st.pop();
    }
    for(i=n; i>=1; i--)
    {
        while(!st.empty() && a[st.top()]>a[i])
        {
            v[st.top()].st=i;
            st.pop();
        }
        st.push(i);
    }
    while(!st.empty())
    {
        v[st.top()].st=0;
        st.pop();
    }
    if(cer==1)
    {
        for(i=1; i<=n; i++)
            if(ok(v[i])) maxim=max(maxim, v[i].dr-v[i].st-1);
        fout<<maxim<<'\n';
    }
    else
    {
        sort(v+1, v+n+1);
        for(ans=ok(v[1]), i=2; i<=n; i++)
            ans+=(v[i]!=v[i-1] && ok(v[i]));
        fout<<ans<<'\n';
    }
}

bool ok(indici a)
{
    return (a.st>=1 && a.dr<=n);
}
